@extends('layouts.app')
@section('css')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css"/>
    <link href="global_assets/css/icons/fontawesome/styles.min.css" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@9.17.2/dist/sweetalert2.css">
@endsection

@section('navigation')
    <a href="{{ route('users.index') }}" class="breadcrumb-item"><i class="icon-stack mr-2"></i> Usuarios</a>
    <span class="breadcrumb-item active">Listado</span>
@endsection

@section('content')
    <div class="content">
        <div class="row">
            @include('flash::message')
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header header-elements-inline">
                        <h5 class="card-title" style="color:black; font-weight:bold;">Usuarios</h5>
                        <a type="button" class="btn btn-outline-primary" style="border-radius:5px;
                        height:35px; font-size:12px; color:#102360;" href="{{ route('users.create') }}"><i class="icon-plus2"></i> Nuevo registro</a>
                    </div>
                    <div class="card-body">
                        <table  id="main-table" class="table table-bordered table-striped table-hover table-sx" cellpadding="0" cellspacing="0" width="100%">
                            <thead >
                                <tr style="text-align:center;" >
                                    <th style="display:none">id</th>
                                    <th>Nombre</th>
                                    <th>Correo electrónico</th>
                                    <th>Activo</th>
                                    <th>Acción</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.2/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9.10.12/dist/sweetalert2.all.min.js"></script>

<script>

    $(function () {
        SearchData();
    });

    function Eliminar (id){
        Swal.fire({
            title: 'Confirmación',
            text: "¿Desea eliminar el registro?",
           // icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3700ff',
            confirmButtonText: 'Eliminar'
            }).then((result) => {
            if (result.value) {
                Deleted(id);
            }
        })
    };

    function Deleted($id){
        var data = [];
        data['id'] = $id;

        $.ajax({
            url: '{{ route('api.users.delete') }}',
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            data: {
                'id': $id
            },
            cache: false,
            async: true,
            dataType: 'json',
            success: function(str){
                if (str.isError) {
                    showError(str.message);
                } else {
                    showSuccess("Registro eliminado con éxito");
                    SearchData();
                }
            },
            error: function(html, textStatus, errorThrown){
                console.log(html, textStatus, errorThrown);
            }
        });
    };

    SearchData = function() {
        $.fn.dataTable.ext.errMode = 'throw';
        var table = $('#main-table');

        table.DataTable({
            "processing": false,
            "serverSide": true,
            "searching": true,
            "destroy": true,
            "responsive": true,
            ajax: {
                "url": '{{ route('api.users.datatable') }}',
                "type": "POST",
                "dataSrc": "data",
                "data": function(d){
                    var frm_data = $('#form_filters').serializeArray();
                    $.each(frm_data, function(key, val) {
                        d[val.name] = val.value;
                    });
                },
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                beforeSend: function (req) {
                    table.mask("Espere por favor..");
                },
                complete: function (req) {
                    table.unmask();
                }
            },
            "drawCallback": function( settings ) {
                $(".tooltips").tooltip({placement: 'top'});
            },
            "pageLength": 20,
            "sDom": '<"pull-left"l><"pull-right"f>t<"pull-left"i><"pull-right"p><"clear">',
            "columns": [
                { data: "id", "visible": false},
                { data: "name", "autowidth": true, responsivePriority: 1},
                { data: "email", "visible": true, "autowidth": true },
                {
                    data: "enabled",
                    width: "70px",
                    class: "text-center",
                    render: function (data, type, row) {
                        var $enabled = (data == 1) ? "checked" : "";
                        var rownew = '<label class="switch"><input type="checkbox" onchange="updateStatus('+ row.id +')" '+$enabled+'><span class="slider round"></span></label>'
                        return rownew;
                    }
                },
                {data: null, class: "text-center", responsivePriority: 2}
            ],
            columnDefs : [
                {
                    "targets": -1,
                    "render": function (data, type, row) {
                        return '<div class="btn-group btn-group-xs">\n' +
                        '<a href="/users/'+ row.id +'/edit"  type="button" class="btn btn-success tooltips" title="Editar"><i class="fa fa-edit"></i></a>\n' +
                        '<a href="#" onClick="Eliminar('  + row.id + ')"type="button" class="btn btn-danger tooltips" title="Eliminar"><i class="fa fa-trash"></i></a>\n' +
                        '</div>';
                    }
                }
            ],
            "order": [[0, "desc"]],
            "language": {
                "url": "/datatables_new/i18n/Spanish.json"
            },
            initComplete: function () {
                $('#search_input').unbind().keyup(function() {
                    var value = $(this).val().trim();
                    table.dataTable().fnFilter(value);
                    //that.search(value, false, false).draw();
                });
            }
        })
    };

    updateStatus = function(id){
        $.ajax({
            url: '{{ route('api.change.status') }}',
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            data: {
                'id'    : id,
                'table' : 'usuarios'
            },
            dataType: 'json',
            beforeSend: function (xhr) {
                $('#main-table').mask("Procesando, espere por favor...");
            }, success: function (jsonResult) {
                $('#main-table').unmask();
                if (jsonResult.isError){
                    GenerarReporte();
                    swal('Advertencia',jsonResult.message,'error');
                }
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert("error general al intentar cambiar el estatus. Avise a administración");
                GenerarReporte();
                $('#main-table').unmask();
            }
        });
    }
</script>
@endsection
