@extends('layouts.app')

@section('content')

<div class="content">
    <div class="row">
        <div class="col-12">
            <input type="hidden" value="{{$familyId}}" id="familyId">
        </div>
    </div>
    <div class="row">
        @foreach ($datawidget as $widget)
            <div class="col-sm-6 col-xl-4">
                <div class="card card-body bg-success-400 has-bg-image">
                    <div class="media mb-3">
                        <div class="mr-3 align-self-center">
                            <i class="fas fa-database fa-3x"></i>
                        </div>
                        <div class="media-body">
                        <h6 class="font-weight-semibold mb-0">{{$widget->platformName}}</h6>
                            <span class="opacity-75">Actualización: {{date('Y-m-d H:i:s')}}</span>
                        </div>
                    </div>
                    <div class="progress bg-success mb-2" style="height: 0.125rem;">
                        <div class="progress-bar bg-white" style="width: {{number_format($widget->storageConsumido * 100 / $widget->storageCapacity,2)}}%">
                            <span class="sr-only">{{number_format($widget->storageConsumido * 100 / $widget->storageCapacity,2)}} Complete</span>
                        </div>
                    </div>
                    <div>
                        <span class="float-right">{{number_format($widget->storageConsumido * 100 / $widget->storageCapacity,2)}}%</span>
                        Porcentaje usado en el servidor
                    </div>
                </div>
            </div>
        @endforeach
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-dark text-white d-flex justify-content-between" style="background-color: #102360e0!important;">
                    <span class="font-size-sm text-uppercase font-weight-semibold">CONSUMO POR PLATAFORMA</span>
                    <span class="font-size-sm text-uppercase font-weight-semibold">{{date('Y-m-d')}}</span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table text-nowrap">
                            <thead>
                                <tr>
                                    <th>Plataforma</th>
                                    <th style="text-align: center;">Consumidos</th>
                                    <th style="text-align: center;">Autorizado</th>
                                    <th style="text-align: center;">Disponibles</th>
                                    <th style="text-align: center;">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($datawidget as $widget)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="mr-3">
                                                    <a href="#" class="btn bg-teal-400 rounded-round btn-icon btn-sm">
                                                        <span class="letter-icon"><i class="fas fa-hdd" style="color:white"></i></span>
                                                    </a>
                                                </div>
                                                <div>
                                                    <a href="#" class="text-default font-weight-semibold">{{$widget->platformName}}</a>
                                                    <div class="text-muted font-size-sm">
                                                        <span class="badge badge-mark border-blue mr-1"></span>
                                                         Creado: {{$widget->createdAt}}
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td style="text-align: center;"><span class="text-success-600"><i class="icon-stats-growth2 mr-2"></i> {{number_format($widget->storageConsumido,2)}}MB</span></td>
                                        <td style="text-align: center;"><h6 class="font-weight-semibold mb-0">{{number_format($widget->storageCapacity,2)}}MB</h6></td>
                                        <td style="text-align: center;"><span class="text-muted">{{number_format($widget->storageCapacity-$widget->storageConsumido,2)}}MB</span></td>
                                        @if($widget->status == true)
                                            <td style="text-align: center;"><span class="badge bg-blue">Activa</span></td>
                                        @else
                                            <td style="text-align: center;"><span class="badge bg-blue">Inactiva</span></td>
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer bg-transparent d-flex justify-content-between border-top-0 pt-0"></div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-dark text-white d-flex justify-content-between" style="background-color: #102360e0!important;">
                    <span class="font-size-sm text-uppercase font-weight-semibold">CONSUMO POR TIPO DE MEDIDA</span>
                    <span class="font-size-sm text-uppercase font-weight-semibold">{{date('Y-m-d')}}</span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table text-nowrap">
                            <thead>
                                <tr>
                                    <th>Plataforma</th>
                                    <th style="text-align: center;">Gigabytes</th>
                                    <th style="text-align: center;">Megabytes</th>
                                    <th style="text-align: center;">Kilobytes</th>
                                    <th style="text-align: center;">Bytes</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($datawidget as $widget)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="mr-3">
                                                    <a href="#" class="btn bg-teal-400 rounded-round btn-icon btn-sm">
                                                        <span class="letter-icon"><i class="fas fa-hdd" style="color:white"></i></span>
                                                    </a>
                                                </div>
                                                <div>
                                                    <a href="#" class="text-default font-weight-semibold">{{$widget->platformName}}</a>
                                                    <div class="text-muted font-size-sm">
                                                        <span class="badge badge-mark border-blue mr-1"></span>
                                                         Creado: {{$widget->createdAt}}
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td style="text-align: center;"><span class="font-weight-semibold mb-0">{{number_format($widget->gigabytesConsumed,2)}}GB</span></td>
                                        <td style="text-align: center;"><h6 class="text-success-600"><i class="icon-stats-growth2 mr-2"></i>{{number_format($widget->megabytesConsumed,2)}}MB</h6></td>
                                        <td style="text-align: center;"><span class="text-muted">{{number_format($widget->kilobytesConsumed,2)}}KB</span></td>
                                        <td style="text-align: center;"><span class="text-muted">{{number_format($widget->bytesConsumed,2)}}</span></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer bg-transparent d-flex justify-content-between border-top-0 pt-0"></div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Storage consumido por plataforma</h5>
                    <h6 class="card-subtitle text-muted" style="margin-top:4px; margin-bottom:-12px;">Año: {{ date('Y') }}</h6>
                    <hr></hr>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <div class="chart has-fixed-height" id="getPorcentajeByPlatform" style="with:100%; height:300px; margin-top:-15px;"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-12 col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Storage consumido por mes</h5>
                    <h6 class="card-subtitle text-muted" style="margin-top:4px; margin-bottom:-12px;">Año: {{ date('Y') }}</h6>
                    <hr></hr>
                </div>

                <div class="card-body">
                    <div class="chart-container">
                        <div class="chart has-fixed-height" id="getStorageByPlatform" style="with:100%; height:300px; margin-top:-15px;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
    <script src="/plugins/echarts/echarts.min.js"></script>
    <script>

            incidenceByYear()
            getPorcentajeByPlatform()

            function incidenceByYear() {
                $.ajax({
                    url: "{{ route('api.home.getStorageUsedByYear') }}",
                    type: "post",
                    headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: {
                        "familyId": $('#familyId').val(),
                    },
                    success: function (data) {
                        var serie =[];
                        var series =[];
                        for (var i = 0; i < data[0].modelo.length; i+=1) {
                            serie = {
                                name: data[0].modelo[i].platformName,
                                type: 'bar',
                                data: [data[0].modelo[i].ENE, data[0].modelo[i].FEB, data[0].modelo[i].MAR, data[0].modelo[i].ABR, data[0].modelo[i].MAY, data[0].modelo[i].JUN, data[0].modelo[i].JUL, data[0].modelo[i].AGO, data[0].modelo[i].SEP, data[0].modelo[i].OCT, data[0].modelo[i].NOV, data[0].modelo[i].DIC]
                            }
                            series.push(serie)
                            console.log(series)
                        }

                        var myChart = echarts.init(document.getElementById('getStorageByPlatform'));
                        var option = {
                            textStyle: {
                                fontFamily: 'Roboto, Arial, Verdana, sans-serif',
                                fontSize: 10
                            },
                            animationDuration: 750,
                            grid: {
                                left: 0,
                                right: 30,
                                top: 35,
                                bottom: 0,
                                containLabel: true
                            },
                            title: {
                                text: 'Megabytes',
                                    textStyle: {
                                        fontFamily: 'Roboto, Arial, Verdana, sans-serif',
                                        fontSize: 12,
                                        left: -25,
                                },
                            },
                            tooltip: {},
                            legend: {
                                data: ['Plataformas'],
                                itemHeight: 8,
                                itemGap: 20,
                                textStyle: {
                                    padding: [0, 5]
                                }
                            },
                            tooltip: {
                                trigger: 'axis',
                                backgroundColor: 'rgba(0,0,0,0.75)',
                                padding: [10, 15],
                                textStyle: {
                                    fontSize: 13,
                                    fontFamily: 'Roboto, sans-serif'
                                },
                                axisPointer: {
                                    type: 'shadow',
                                    shadowStyle: {
                                        color: 'rgba(0,0,0,0.025)'
                                    }
                                }
                            },
                            xAxis: {
                                data: ["ENE", "FEB", "MAR", "ABR", "MAY","JUN", "JUL" , "AGO" , "SEP" , "OCT" , "NOV" , "DIC"]
                            },
                            yAxis: {},
                            series: series
                        };
                        myChart.setOption(option);
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        Swal.fire({
                            type: 'error',
                            title: 'Registro',
                            text: 'error al cargar información, intente mas tarde!',
                        })
                    }
                });
            }

            function getPorcentajeByPlatform() {

                $.ajax({
                    url: "{{ route('api.home.getPorcentajeByPlatform') }}",
                    type: "post",
                    headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: {
                        "familyId": $('#familyId').val(),
                    },
                    success: function (data) {

                        var myChart = echarts.init(document.getElementById('getPorcentajeByPlatform'));
                        var statusNames = [];
                        var statusTotal =[];
                        var Statistical = data[0].modelo;
                        option = {

                            tooltip: {
                                trigger: 'item',
                                formatter: '{a} <br/>{b} : {c} ({d}%)'
                            },
                            legend: {
                                orient: 'vertical',
                                left: 'left',
                                data: statusNames
                            },
                            series: [
                                {
                                    name: 'Estatus',
                                    type: 'pie',
                                    radius: '75%',
                                    center: ['50%', '50%'],
                                    data: Statistical,
                                    emphasis: {
                                        itemStyle: {
                                            shadowBlur: 10,
                                            shadowOffsetX: 0,
                                            shadowColor: 'rgba(0, 0, 0, 0.5)'
                                        }
                                    }
                                }
                            ]
                        };
                        myChart.setOption(option);
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Registro',
                            text: 'error al cargar información, intente mas tarde!',
                        })
                    }
                });
            }

    </script>
 @endsection

 @section('style')
    <style>
        hr {
        height: 10px;
        }
    </style>
@endsection
