<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model as Model;


class SystemLog extends Model
{

    public $table = 'system_logs';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';

    const Info = 1;
    const Warning = 2;
    const Exception = 3;
    const AppException = 4;

    public $fillable = [
        'controller',
        'message',
        'type',
        'userId'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id'         => 'integer',
        'controller' => 'string',
        'message'    => 'string',
        'type'       => 'integer',
        'userId'     => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'id'         => 'required',
        'controller' => 'required',
        'message'    => 'required',
        'type'       => 'required',
        'userId'     => 'required'
    ];

}
