<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\ApiError;
use App\Http\Requests\UpdateGeneralRequest;
use App\Services\GeneralService;
use Laracasts\Flash\Flash;

class GeneralController extends Controller
{

    private $service;

    public function __construct(GeneralService $service)
    {
        $this->middleware('auth');
        $this->service = $service;
    }

    public function datatable(Request $request) {
        $table = $this->service->dataTable($request);
        return $table;
    }

    public function index() {
        $row = $this->service->getGeneral(1);
        if ($row == null) {
            Flash::error(('Registro NO encontrado'));
        }
        return view('generals.index')->with('row', $row);
    }

    public function create() {
        return view('generals.create');
    }

    public function update($id,UpdateGeneralRequest $request) {
        $apiError = $this->service->update($id, $request);
        return redirect(route('general.index'));
    }

    public function delete(Request $request) {
        $apiError = $this->service->delete($request->id);
        return response()->json($apiError);
    }
}
