<?php

namespace App\Http\Controllers;

use App\Exceptions\AppException;
use App\Models\ApiError;
use App\Models\AccessType;
use App\Models\Bucket;
use App\Models\FileType;
use App\Models\Platform;
use App\Models\PlatformFamily;
use App\Models\CallHistory;
use App\Models\User;
use App\Models\SystemLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use InfyOm\Generator\Utils\ResponseUtil;
use Laracasts\Flash\Flash;
use Response;

class AppBaseController extends Controller
{
    public function sendResponse($result, $message)
    {
        return Response::json(ResponseUtil::makeResponse($message, $result));
    }

    public function sendError($error, $code = 404)
    {
        return Response::json(ResponseUtil::makeError($error), $code);
    }

    public function sendSuccess($message)
    {
        return Response::json([
            'success' => true,
            'message' => $message
        ], 200);
    }

    protected function jsonResponse($resource) {
        $response = [
            'message'   => $resource->message,
            'code'      => $resource->code,
            'isError'   => $resource->isError,
            'errors'    => $resource->errors,
            #'request'   => $resource->request,
            'data'      => ''
        ];

        if(isset($resource->contact)) $response['contact'] = $resource->contact;

        if(isset($resource->resource)) {
            $response['data'] = $resource->resource;
        } else {
            $response['data'] = $resource->modelo;
        }

        return response()->json($response, ($resource->code != 204)  ? $resource->code : 200);
    }

    public function setLog($sMessage, $iType = SystemLog::Info) {

        $values = request()->route()->getAction();

        $controller = $values["controller"];
        $method = request()->route()->getActionMethod();

        try {
            $userId = "";

            if (Auth::check()) {
                $userId = auth()->user()->id;
            }

            SystemLog::create([
                'controller' => $method."->".$controller,
                'message' => $sMessage,
                'type' => $iType,
                'userId' => $userId,
            ]);

        } catch (\Exception $e) {
            $sMessage = $e->getMessage();
            #dd($sMessage);
        }

        try {
            if ($iType ==  SystemLog::Exception)
                Log::error($controller . "-" . $userId . "-" . $sMessage);

            else if ($iType == SystemLog::Info)
                Log::info($controller . "-" . $userId . "-" . $sMessage);

            else if ($iType == SystemLog::Warning)
                Log::warning($controller . "-" . $userId . "-" . $sMessage);

        } catch (\Exception $e) {}
    }

    public function updateStatus(Request $request){
        $apiError =  new ApiError();

        # SELECCIONAMOS LA TABLA A LA CUAL SE LE VA A ACTUALIZAR
        if($request->table == 'usuarios') $row = User::whereId($request->id)->first();
        if($request->table == 'accesstypes') $row = AccessType::whereId($request->id)->first();
        if($request->table == 'filetypes') $row = FileType::whereId($request->id)->first();
        if($request->table == 'platform') $row = Platform::whereId($request->id)->first();
        if($request->table == 'platform_family') $row = PlatformFamily::whereId($request->id)->first();
        if($request->table == 'buckets') $row = Bucket::whereId($request->id)->first();

        try {
            if (empty($row)) throw new AppException("Registro NO encontrado.");

            $row->enabled = !$row->enabled;
            $row->save();
            $description = "updateStatus" . " " . $row->name;
            $this->saveHistory('patch',$request->table, $description);
        } catch (\AppException $ex ) {
            $apiError->setError($ex->getMessage());

        } catch (\Exception $ex ) {
            $this->setLog("Linea: ".$ex->getLine()." | MSG: ".$ex->getMessage(), SystemLog::Exception);
            $apiError->setError($ex->getMessage());
        }

        return response()->json($apiError);
    }

    public function saveHistory($method,$service,$description)
    {
        try{

            $apiError =  new ApiError();
            $user = Auth::user();
            $platform = Platform::where('userId',$user->id)->first();

            if($platform == null){
                $row = CallHistory::create([
                    'userId'        => $user->id,
                    'method'        => $method,
                    'service'       => $service,
                    'description'   => $description
                ]);
            }else{
                $row = CallHistory::create([
                    'userId'        => $user->id,
                    'platformId'    => $platform->id,
                    'method'        => $method,
                    'service'       => $service,
                    'description'   => $description
                ]);
            }
            $apiError->modelo = $row;
        }catch (\AppException $ex ) {
            $apiError->setError($ex->getMessage());
        } catch (\Exception $ex ) {
            $this->setLog("Linea: ".$ex->getLine()." | MSG: ".$ex->getMessage(), SystemLog::Exception);
            $apiError->setError($ex->getMessage());
        }
        return response()->json($apiError);
    }
}

